/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.pi.PIHscFoDCIMClient;
import com.ibm.hsc.client.PIFoDKeyDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCFoDClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class PIVetChange {
    private static final int NUM_VALID_PARMS = 3;
    private String m_managedSystem;
    private String m_operation;
    private String m_code;
    private HashMap m_validParms = new HashMap(7, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFoDClient m_fodClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;
    private static final String INVALID_KEY_CONFIRMATION_ID = "1000";

    private PIVetChange(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-o", null);
        this.m_validParms.put("-k", null);
    }

    private int doEnterCodeOperation() throws PIHscClientException {
        PIFoDKeyDataBean pIFoDKeyDataBean = this.m_fodClient.setFoDKey(this.m_code);
        if (pIFoDKeyDataBean.getConfNeededVal()) {
            this.m_out.print(pIFoDKeyDataBean.getKeyInfoMsg());
            String string = pIFoDKeyDataBean.getConfMsgID();
            String string2 = null;
            if (!INVALID_KEY_CONFIRMATION_ID.equals(string)) {
                throw new PIHscClientException("9003", "HSCCIMExceptionBundle", "9003", null, null);
            }
            string2 = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "FOD_INVALID_KEY_CONFIRMATION");
            boolean bl = PIHMCCommandUtils.doConfirmation(string2);
            if (bl) {
                pIFoDKeyDataBean = this.m_fodClient.setFoDKey(1, Integer.parseInt(string), this.m_code);
            } else {
                return 1;
            }
        }
        return 0;
    }

    private int performCommand() throws PIHscClientException {
        int n = 0;
        this.checkParameters();
        this.m_fodClient = PIHscFoDCIMClient.createInstance(this.m_CECClient);
        n = this.doEnterCodeOperation();
        return n;
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (this.m_operation == null || !"e".equals(this.m_operation)) {
            string = string + ", -o";
        }
        if (this.m_code == null || this.m_code.length() == 0) {
            string = string + ", -k";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_operation = (String)hashMap.get("-o");
        this.m_code = (String)hashMap.get("-k");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHVET_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIVetChange pIVetChange = new PIVetChange(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIVetChange.m_validParms);
            pIVetChange.mapParameters(hashMap);
            n = pIVetChange.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        if (bl) {
            if (n == 0) {
                printStream.print('\u0000');
            } else {
                printStream.print('\u0001');
            }
        }
        return n;
    }
}

